/*
 *  File:		main.c
 *  Function:	main entry for the icon picker/editor
 *  Author:		Paul Elseth
 *				Copyright (c) 1991, Paul Elseth
 *
 *	Change History:
 *
 *		12/02/91	PBE		created
 */

#ifndef __FOUNDATION__
#include "foundation.h"
#endif	
#ifndef	__PICKER__
#include "picker.h"
#endif
#ifndef	__EDITOR__
#include "editor.h"
#endif
#ifndef	__GLOBALS__
#include "globals.h"
#endif
#ifndef	__UTILS__
#include "utils.h"
#endif
#ifndef	__MEMUTILS__
#include "memUtils.h"
#endif
#ifndef	__OPTIONS__
#include "options.h"
#endif

#pragma noroot


#define	FOR_SELECTOR	(1 << 10)


/*
 *	Initialize()
 *		Init global values.
 */
static
short Initialize(fStartStopRec *parms)
{
	gUserID = parms->edUserID;

	gEdResFile = parms->edResFileID;
	gShResFile = parms->shResFileID;
/*	gPrefResFile = parms->fdResFileID;	*/

	gToolsPicH = nil;

	return 0;
}


/*
 *	Shutdown()
 *		Shutdown the entire thing.
 */
static
short Shutdown(fStartStopRec *parms)
{
	if (gToolsPicH != nil)
		DisposeIfHandle((Handle) gToolsPicH);

	return 0;
}


short REM_OPEN(fOpenRec *parms)
{
	short	err;

	if (parms->fFlag & FOR_SELECTOR)
		err = OpenPicker(parms);
	else
		err = OpenEditor(parms);

	if (err != 0)
		SysError(err);

	return err;
}

short REM_CLOSE(fCloseRec *parms)
{   
	short	err;

	if (parms->fFlag & FOR_SELECTOR)
		err = ClosePicker(parms);
	else
		err = CloseEditor(parms);
		
	if (err != 0)
		SysError(err);

	return err;
}

short REM_WRITE(fCloseRec *parms)
{
	short	err;

	if (parms->fFlag & FOR_SELECTOR)
		err = WritePicker(parms);
	else
		err = WriteEditor(parms);

	if (err != 0)
		SysError(err);

	return err;
}

short REM_EVENT(fEventRec *parms)
{
	short	err;

	if (parms->fFlag & FOR_SELECTOR)
		err = PickerEvent(parms);
	else
		err = EditorEvent(parms);

	if (err != 0)
		SysError(err);

	return err;
}

short REM_ACTIVATE(fActivateRec *parms)
{
	short	err;

	if (parms->fFlag & FOR_SELECTOR)
		err = ActivatePicker(parms);
	else
		err = ActivateEditor(parms);

	if (err != 0)
		SysError(err);

	return err;
}   

short REM_GETLINK(fLinkRec *parms)
{
	short	err;

	err = EditorGetLink(parms);

	if (err != 0)
		SysError(err);

	return err;
}   

short REM_VIDMODE(fVidModeRec *parms)
{
	short	err;

	if (parms->fFlag & FOR_SELECTOR)
		err = PickerVidMode(parms);
	else	
		err = EditorVidMode(parms);

	if (err != 0)
		SysError(err);

	return err;
}

short REM_PRINT(fCloseRec *parms)
{
	short	err;

	if (parms->fFlag & FOR_SELECTOR)
		err = PickerPrint(parms);
	else
		err = EditorPrint(parms);

	if (err != 0)
		SysError(err);

	return err;
}   

short REM_STARTUP(fStartStopRec *parms)
{
	short	err;

	err = Initialize(parms);

	if (err != 0)
		SysError(err);

	return err;
}

short REM_SHUTDOWN(fStartStopRec *parms)
{
	short	err;

	err = Shutdown(parms);

	if (err != 0)
		SysError(err);

	return err;
}
